#include <bits/stdc++.h> 
using namespace std;

bool valid_index(long long index, long long n) {
    return index>=0 && index<n;
}
char res[(long long)1e6];
long long operations = 0;
long long killed = 0;
long long closestNorth;
long long closestSouth;
long long lastOperation = -1;
long long curPos = 0;


void killNorth() {
    killed++;
    closestNorth++;
    lastOperation = 1;
}

void killSouth() {
    killed++;
    closestSouth--;
    lastOperation = 2;
}

void move() {
    curPos++;
    lastOperation = 3;
}


int main() {
    ios_base::sync_with_stdio(false);
    int n;
    cin>>n;
    vector<long long> a(n);
    for (long long i = 0; i<n; i++) {
        cin>>a[i];
    }

    sort(a.begin(), a.end());
    
    closestNorth = lower_bound(a.begin(), a.end(), 0) - a.begin();
    closestSouth = closestNorth - 1;

    while (operations < 1e6 && (valid_index(closestNorth, n) || valid_index(closestSouth, n))) {
        long long distanceNorth = (valid_index(closestNorth, n)) ? a[closestNorth] - curPos - operations : numeric_limits<long long>::max();
        long long distanceSouth = (valid_index(closestSouth, n)) ? curPos - a[closestSouth] - operations : numeric_limits<long long>::max();

        if (distanceSouth <= 0 || distanceNorth <= 0) break;

        if (lastOperation == 1) {
            killSouth();

        }


        else if (lastOperation == 2) {
            if (distanceNorth < distanceSouth) {
                killNorth();
            }
            else {
                move();
            }
        }

        else {
            if (distanceNorth < distanceSouth) {
                killNorth();
            }

            else {
                killSouth();
            }
        }

        res[operations++] = lastOperation;
    }


    cout<<killed<<'\n';

    for (long long i = 0; i<operations; i++) {
        cout<<(int)res[i];
    }

}